ss.power.R2              package:MBESS              R Documentation

_F_u_n_c_t_i_o_n _t_o _p_l_a_n _s_a_m_p_l_e _s_i_z_e _s_o _t_h_a_t _t_h_e _t_e_s_t _o_f _t_h_e _s_q_u_r_e_d _m_u_l_t_i_p_l_e _c_o_r_r_e_l_a_t_i_o_n _c_o_e_f_f_i_c_i_e_n_t _i_s _s_u_f_f_i_c_i_e_n_t_l_y _p_o_w_e_r_f_u_l.

_D_e_s_c_r_i_p_t_i_o_n:

     Function for determining the necessary sample size for the test of
     the squared multiple correlation  coefficient or for determining
     the statistical power given a specified sample size for  the
     squared multiple correlation coefficient in models where the
     regressors are regarded as fixed.

_U_s_a_g_e:

     ss.power.R2(Population.R2 = NULL, alpha.level = 0.05, desired.power = 0.85,
     p, Specified.N = NULL, Cohen.f2 = NULL, Null.R2 = 0, 
     Print.Progress = FALSE, ...)

_A_r_g_u_m_e_n_t_s:

Population.R2: Population squared multiple correlation coefficient

alpha.level: Type I error rate

desired.power: desired degree of statistical power

       p: the number of predictor variables

Specified.N: the sample size used to calculate power (rather than
          determine necessary sample size)

Cohen.f2: Cohen's (1988) effect size for multiple regression:
          'Population.R2/(1-Population.R2)'

 Null.R2: value of the null hypothesis that the squared multiple
          correlation will be evaluated against (this will typically be
          zero)

Print.Progress: if the progress of the iterative procedure is printed
          to the screen as the iterations are occuring

     ...: (not currently implemented) possible additional parameters
          for internal functions

_D_e_t_a_i_l_s:

     Determine the necessary sample size given a particular
     'Population.R2', 'alpha.level', 'p', and 'desired.power'.
     Alternatively, given 'Population.R2', 'alpha.level', 'p', and
     'Specified.N', the function can be used to determine the
     statistical power.

_V_a_l_u_e:

Sample.Size: returns either 'Necessary.Sample.Size' or
          'Specified.Sample.Size', depending on if sample size is being
          determined for a desired degree of statistical power analysis
          or if statistical power is being determined given a specified
          sample size, respectively

Actual.Power: Actual power of the situation described

_N_o_t_e:

     When determining sample size for a desired degree of power, there
     will always be a  slightly larger degree of actual power. This is
     the case because the algorithm employed  determines sample size
     until the actual power is no less than the  desired power (given
     sample size is a whole number power will almost certainly  not be
     exactly the specified value). This is the same as other
     statistical power  procedures that return whole numbers for
     necessary sample size.

_A_u_t_h_o_r(_s):

     Ken Kelley (Indiana University; KKIII@Indiana.Edu)

_S_e_e _A_l_s_o:

     'ss.aipe.R2', 'ss.power.reg.coef', 'conf.limits.ncf'

_E_x_a_m_p_l_e_s:

     ss.power.R2(Population.R2=.5, alpha.level=.05, desired.power=.85, p=5)
     ss.power.R2(Cohen.f2=1, alpha.level=.05, desired.power=.85, p=5)
     ss.power.R2(Population.R2=.5, Specified.N=15, alpha.level=.05, 
     desired.power=.85, p=5)
     ss.power.R2(Cohen.f2=1, Specified.N=15, alpha.level=.05, desired.power=.85, p=5)

