### Name: ci.R2
### Title: Confidence intervals for the squared multiple correlation
###   coefficient
### Aliases: ci.R2
### Keywords: multivariate htest regression

### ** Examples

# For random predictor variables.
ci.R2(R2=.25, N=100, K=5, conf.level=.95, Random.Predictors=TRUE)

ci.R2(F.value=6.266667, N=100, K=5, conf.level=.95, Random.Predictors=TRUE)

# For fixed predictor variables.
ci.R2(R2=.25, N=100, K=5, conf.level=.95, Random.Predictors=TRUE)

ci.R2(F.value=6.266667, N=100, K=5, conf.level=.95, Random.Predictors=TRUE)

# One sided confidence intervals when predictors are random.
ci.R2(R2=.25, N=100, K=5, alpha.lower=.05, alpha.upper=0, conf.level=NULL,
Random.Predictors=TRUE)

ci.R2(R2=.25, N=100, K=5, alpha.lower=0, alpha.upper=.05, conf.level=NULL,
Random.Predictors=TRUE)

# One sided confidence intervals when predictors are fixed.
ci.R2(R2=.25, N=100, K=5, alpha.lower=.05, alpha.upper=0, conf.level=NULL,
Random.Predictors=FALSE)

ci.R2(R2=.25, N=100, K=5, alpha.lower=0, alpha.upper=.05, conf.level=NULL,
Random.Predictors=FALSE)



