### Name: ss.aipe.R2
### Title: Sample Size Planning for Accuracy in Parameter Estimation for
###   the multiple correlation coefficient.
### Aliases: ss.aipe.R2
### Keywords: design

### ** Examples

# Returned sample size should be considered approximate; exact sample
# size is obtained by specifying the argument 'verify.ss=TRUE' (see below).
ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
p=5, Random.Predictors=TRUE)
# Uncomment to run in order to get exact sample size.
# ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
# p=5, Random.Predictors=TRUE, verify.ss=TRUE)

# Same as above, except the predictor variables are considered fixed.
# Returned sample size should be considered approximate; exact sample
# size is obtained by specifying the argument 'verify.ss=TRUE'.
ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
p=5, Random.Predictors=FALSE)
# Uncomment to run in order to get exact sample size.
#ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
#p=5, Random.Predictors=FALSE, verify.ss=TRUE)

# Returned sample size should be considered approximate; exact sample
# size is obtained by specifying the argument 'verify.ss=TRUE'.
ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
p=5, degree.of.certainty=.85, Random.Predictors=TRUE)
# Uncomment to run in order to get exact sample size.
#ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
#p=5, degree.of.certainty=.85, Random.Predictors=TRUE, verify.ss=TRUE)

# Same as above, except the predictor variables are considered fixed.
# Returned sample size should be considered approximate; exact sample
# size is obtained by specifying the argument 'verify.ss=TRUE'.
ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
p=5, degree.of.certainty=.85, Random.Predictors=FALSE)
# Uncomment to run in order to get exact sample size.
#ss.aipe.R2(Population.R2=.50, conf.level=.95, width=.10, which.width="Full",
#p=5, degree.of.certainty=.85, Random.Predictors=FALSE, verify.ss=TRUE)



