### Name: vit
### Title: Visualize individual trajectories
### Aliases: vit
### Keywords: hplot device dynamic

### ** Examples


data(Gardner.LD)

# Although many options are possible, a simple call to
# 'vit' is of the form:
vit(id="ID", occasion= "Trial", score= "Score", Data=Gardner.LD)

# Now color is conditional on group membership.
vit(id="ID", occasion= "Trial", score="Score", Data=Gardner.LD, 
group="Group")

# Now randomly selects 50
vit(id="ID", occasion= "Trial", score="Score", Data=Gardner.LD, 
pct.rand=50, group="Group")

# Specified individuals are plotted (by group)
vit(id="ID", occasion= "Trial", score="Score", Data=Gardner.LD, 
subset.ids=c(1, 4, 8, 13, 17, 21), group="Group")

# Now colors for groups are changed .
vit(id="ID", occasion= "Trial", score="Score", Data=Gardner.LD, 
group="Group",subset.ids=c(1, 4, 8, 13, 17, 21), col=c("Green", "Blue"))

# Now each individual specified is plotted seperately.
vit(id="ID", occasion= "Trial", score="Score", Data=Gardner.LD, 
group="Group",subset.ids=c(1, 4, 8, 13, 17, 21), col=c("Green", "Blue"),
All.in.One=FALSE)




