### Name: rfm.test
### Title: MC test on random field model
### Aliases: rfm.test
### Keywords: spatial

### ** Examples

data(BITOEK)
d <- steigerwald
plotWithCircles(cbind(d$coord, d$diam), factor=2)
mpp.characteristics(x=d$coord, data=d$diam,
                    bin=c(-1, seq(0, 50, 2)), show=interactive())

## testing for E=const, V=const or SD=const (this takes several minutes!)
res <- rfm.test(d$coord, d$diam, MCrep=if (interactive()) 99 else 9,
                n.hypo=if (interactive()) 100 else 2)

## test statistics for the data
res$E
res$VAR

## reference values for the estimated 10%, 5% and 1% level
res$null.sl

## should E=const, V=const or SD=const be rejected at the given levels?
res$reject.null 



