fillX.G             package:MasterBayes             R Documentation

_M_e_n_d_e_l_i_a_n _T_r_a_n_s_i_t_i_o_n _P_r_o_b_a_l_i_t_i_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     This function is primarily intended for use within 'getXlist', and
     fills in the design matrices of the model with the genetic
     likelihoods.  The model of genotyping error for codominant markers
     is taken from CERVUS (Kalinowski, 2006; Marshall, 1998), and the
     model for dominant markers is taken from (Hadfield, 2007).

_U_s_a_g_e:

     fillX.G(X.list, A, G, E1=0.005, E2=0.005, marker.type="MS", ...)

_A_r_g_u_m_e_n_t_s:

  X.list: list of design matrices for each offspring derived using
          'getXlist'

       A: list of allele frequencies

       G: list of genotype objects; rows must correspond to individuals
          in the vector 'X.list$id'

      E1: the probability of a dominant allele being scored as a
          recessive allele for dominant markers

      E2: per-allele genotyping error rate. 'E2'(2-'E2') is the
          per-genotype rate defined in Kalinowski (2006) for codominant
          markers, and 'E2' is the probability of a recessive allele
          being scored as a dominant allele for dominant markers

marker.type: "MS" or "AFLP" for codominant or dominant markers
          respectively

     ...: further arguments to be passed

_V_a_l_u_e:

     list of design matrices of the form 'X.list' containing genetic
     likelihoods for each offspring.

_N_o_t_e:

     If a  'GdataPed' object is passed to 'getXlist' then the genetic
     likelihoods will be calculated by default.

_A_u_t_h_o_r(_s):

     Jarrod Hadfield j.hadfield@sheffield.ac.uk

_R_e_f_e_r_e_n_c_e_s:

     Kalinowski S.T. _et al_ (2006) Molecular Ecology _in press_
     Hadfield J. D. _et al_ (2007) _in prep_

_S_e_e _A_l_s_o:

     'getXlist'

_E_x_a_m_p_l_e_s:

     data(WarblerG)
     A<-extractA(WarblerG)

     ped<-matrix(NA, 5,3)
     ped[,1]<-1:5
     ped[,2]<-c(rep(NA, 4), 1)
     ped[,3]<-c(rep(NA, 4), 2)

     genotypes<-simgenotypes(A, ped=ped)

     sex<-c("Female", "Male", "Female", "Male","Female")
     offspring<-c(0,0,0,0,1)

     data<-data.frame(id=ped[,1], sex, offspring)

     res1<-expression(varPed(x="offspring", restrict=0))

     PdP<-PdataPed(formula=list(res1), data=data)
     GdP<-GdataPed(G=genotypes$Gobs, id=genotypes$id)

     X.list<-getXlist(PdP)
     # creates design matrices for offspring (in this case indivdiual "5")

     X.list.G<-fillX.G(X.list, A=A, G=genotypes$Gobs, E2=0.005)
     # genetic likelihoods are arranged sires within dams 

     X.list.G$X$"5"$dam.id
     X.list.G$X$"5"$sire.id

     # so for this example we have parental combinations 
     # ("1","2"), ("1","4"), ("3","2"), ("2","4"):

     X.list.G$X$"5"$G

     # The true parents have the highest likelihood in this case

