### Name: beta.loglik
### Title: Log-Likelihood of Beta
### Aliases: beta.loglik
### Keywords: models

### ** Examples

data(WarblerP)
data(WarblerG)

GdP<-GdataPed(WarblerG)

res1<-expression(varPed("offspring", relational=FALSE, restrict=0))
var1<-expression(varPed(c("lat", "long"), gender="Male", 
  relational="OFFSPRING"))
res2<-expression(varPed("terr", gender="Female", relational="OFFSPRING", 
  restrict=TRUE))

PdP<-PdataPed(formula=list(var1,res1,res2), data=WarblerP)

# probability of paternity is modelled as a function of  distance 

X.list<-getXlist(PdP=PdP, GdP=GdP)

ped<-MLE.ped(X.list)

# get ML pedigree from genetic data alone

X<-lapply(X.list$X, function(x){list(S=x$XSs)})

# Extract Design matrices for Sires 

sire_pos<-match(ped[,3][as.numeric(names(X))], X.list$id)
sire_pos<-mapply(function(x,y){match(x, y$sire.id)}, sire_pos, X.list$X)

# row number of each design matrix correspoding to the ML sire. 

beta<-seq(-0.065,-0.0325, length=100)
beta_Loglik<-1:100
  for(i in 1:100){
     beta_Loglik[i]<-beta.loglik(X, sire_pos=sire_pos, beta=beta[i], 
     beta_map=X.list$beta_map) 
  }

plot(beta_Loglik~beta, type="l", main="Profile Log-likelihood for beta")



