### Name: cenken
### Title: Compute Kendall's tau correlation coefficient and associated
###   line for censored data. Computes the Akritas-Theil-Sen nonparametric
###   line, with the Turnbull estimate of intercept.
### Aliases: cenken
### Keywords: regression

### ** Examples

    # Both y and x are censored
    # (exercise 11-1 on pg 198 of the NADA book)
    data(Golden)
    with(Golden, cenken(Blood, BloodCen, Kidney, KidneyCen))

    # x is not censored
    # (example on pg 213 of the NADA book)
    data(TCEReg)
    with(TCEReg, cenken(log(TCEConc), TCECen, PopDensity))

    # formula interface
    with(TCEReg, cenken(Cen(log(TCEConc), TCECen)~PopDensity))

    # Plotting data and the regression line
    data(DFe)
    # Recall x and y parameter positons are swapped in plot vs regression calls
    with(DFe, cenxyplot(Year, YearCen, Summer, SummerCen))    # x vs. y
    reg = with(DFe, cenken(Summer, SummerCen, Year, YearCen)) # y~x
    lines(reg)



