matrix.D               package:PHYLOGR               R Documentation

_P_r_o_d_u_c_e _t_h_e _M_a_t_r_i_x _D _o_f _G_a_r_l_a_n_d _a_n_d _I_v_e_s (_2_0_0_0) _f_o_r _G_L_S

_D_e_s_c_r_i_p_t_i_o_n:

     Produces the matrix D in Garland and Ives, 2000, p. 361, for
     further use in GLS procedures. You will rarely need to call this
     function directly. It is called by phylog.gls.fit.

_U_s_a_g_e:

     matrix.D(x)

_A_r_g_u_m_e_n_t_s:

       x: a phylogenetic variance-covariance matrix, such as a matrix
          returned from a call to read.phylog.matrix. 

_V_a_l_u_e:

     A variance-covariance matrix.

_N_o_t_e:

     The file read is a dsc file generated from PDDIST under option 5
     with the additional options : - in matrix form; - with header; -
     with scaled values.

_A_u_t_h_o_r(_s):

     Ramon Diaz-Uriarte and Theodore Garland, Jr.

_R_e_f_e_r_e_n_c_e_s:

     Diaz-Uriarte, R., and Garland, T., Jr., in prep. PHYLOGR: an R
     package for the analysis of comparative data via Monte Carlo
     simulations and generalized least squares approaches.

     Garland, T. Jr. and Ives, A. R. (2000) Using the past to predict
     the present: confidence intervals for regression equations in
     phylogenetic comparative methods. _The American Naturalist_, 155,
     346-364.

_S_e_e _A_l_s_o:

     'read.phylog.matrix', 'phylog.gls.fit'

_E_x_a_m_p_l_e_s:

     #perform GLS using lm function after transforming the variables
     data(Lacertid.varcov)
     mD <- matrix.D(Lacertid.varcov)
     data(Lacertid.Original)
     # obtain transformed variables
     Z <- mD %*% Lacertid.Original$clutch.size
     U <- mD %*% cbind(rep(1,18),Lacertid.Original$svl) # intercept included
     lm1 <- lm(Z ~ U - 1) # eliminate intercept, since already included in U matrix
     summary(lm1)

