### Name: loess.psa
### Title: Graphical and loess based estimate of effect size using
###   propensity scores
### Aliases: loess.psa
### Keywords: hplot

### ** Examples

#Artificial example where dee should be 1.5 over all of (0,1).
#Over the 4 subintervals provided should be 1.5 as well as is 
#symmetric about .5
response <- c(rep(1,150), rep(2,150), rep(0,300))
treatment <- c(rep(1,300), rep(0,300))
propensity <- rep(seq(.01, .99, (.98/299)), 2)
a <- data.frame(response, treatment, propensity)
loess.psa(a, span = .15, degree = 1, int = c(.1, .3, .5, .7, .9))

#Artificial example where estimates are unstable with varying 
#numbers of strata. Note: sometimes get empty treatment/strata error.
rr <- c(rnorm(150, 3, .75), rnorm(700, 0, .75), rnorm(150, 3, .75), 
     rnorm(150, -3, .75), rnorm(700, 0, .75), rnorm(150, -3, .75))
tt <- c(rep(1, 1000),rep(0, 1000))
pp <- NULL
for(i in 1:1000){pp <- c(pp, rnorm(1, 0, .05) + .00045*i + .25)}
for(i in 1:1000){pp <- c(pp, rnorm(1, 0, .05) + .00045*i + .4)}
a <- data.frame(rr, tt, pp)
loess.psa(a, span=.5, cex = .6)

#Using strata of possible interest as determined by loess lines.
data(lindner)
attach(lindner)
lindner.ps <- glm(abcix ~ stent + height + female + 
      diabetic + acutemi + ejecfrac + ves1proc, 
      data = lindner, family = binomial)
loess.psa(log(cardbill), abcix, lindner.ps$fitted,  
         int = c(.37, .56, .87, 1), lines = TRUE)
         abline(v=.37)
         abline(v=.56)
         abline(v=.87)



