### Name: CAPM.utils
### Title: utility functions for CAPM CML, SML, and RiskPremium
### Aliases: CAPM.utils CAPM.RiskPremium CAPM.CML CAPM.CML.slope
###   CAPM.SML.slope
### Keywords: ts multivariate distribution models

### ** Examples

data(edhec)
edhec.length = dim(edhec)[1]
start = rownames(edhec[1,])
start
end = rownames(edhec[edhec.length,])
rf = download.RiskFree(start = start, end = end)

Rb = edhec[,"Funds.of.Funds"]

CAPM.CML.slope(Rb, rf )

CAPM.CML(edhec[,"Equity.Market.Neutral"], Rb, rf)

CAPM.RiskPremium(Rb, rf)

CAPM.RiskPremium(edhec[,"Equity.Market.Neutral"], rf)

CAPM.SML.slope(Rb, rf)

# should create plots like in Ruppert 7.1 7.2




