### Name: KellyRatio
### Title: calculate Kelly criterion ratio (leverage or bet size) for a
###   strategy
### Aliases: KellyRatio
### Keywords: ts multivariate distribution models

### ** Examples

    data(edhec)
                                                                                                                                                              edhec.length = dim(edhec)[1]
    start = rownames(edhec[1,])
    end = rownames(edhec[edhec.length,])

    rf.zoo = download.RiskFree(start = start, end = end)

    for (i in 1:ncol(edhec)) {print(colnames(edhec)[i]); print(KellyRatio(edhec[,i],rf=rf.zoo))}



