### Name: Return.excess
### Title: Calculates the returns of an asset in excess of the given risk
###   free rate
### Aliases: Return.excess
### Keywords: ts multivariate distribution models

### ** Examples

data(edhec)
edhec.length = dim(edhec)[1]
start = rownames(edhec[1,])
end = rownames(edhec[edhec.length,])

rf.zoo = download.RiskFree(start = start, end = end)

Return.excess(edhec[,"Funds.of.Funds"],rf.zoo)
Return.excess(edhec[,"Long.Short.Equity"],rf.zoo)

sp.zoo = download.SP500PriceReturns(start = start, end = end)
Return.excess(edhec[,"Funds.of.Funds"],sp.zoo)
Return.excess(edhec[,"Long.Short.Equity"],sp.zoo)



