### Name: VaR.CornishFisher
### Title: calculate various Value at Risk (VaR) measures
### Aliases: VaR.CornishFisher VaR.traditional VaR.mean VaR modifiedVaR
### Keywords: ts multivariate distribution models

### ** Examples

    data(edhec)

    # first do normal VaR calc
    VaR.traditional(edhec, p=.95)

    # now use modified Cornish Fisher calc to take non-normal distribution into account
    VaR.CornishFisher(edhec, p=.95)

    # now use default p=.99
    VaR.CornishFisher(edhec)




