### Name: chart.TimeSeries
### Title: Creates a time series chart with some extensions.
### Aliases: chart.TimeSeries
### Keywords: ts multivariate distribution models hplot

### ** Examples


# These are start and end dates, formatted the same way as the default axis labels
cycles.dates = list(
    c("10/26","11/27"),
    c("08/29","03/33"),
    c("05/37","06/38"),
    c("02/45","10/45"),
    c("11/48","10/49"),
    c("07/53","05/54"),
    c("08/57","04/58"),
    c("04/60","02/61"),
    c("12/69","11/70"),
    c("11/73","03/75"),
    c("01/80","07/80"),
    c("07/81","11/82"),
    c("07/90","03/91"),
    c("03/01","11/01"))
# Event lists - FOR BEST RESULTS, KEEP THESE DATES IN ORDER
risk.dates = c(
    "10/87",
    "02/94",
    "07/97",
    "08/98",
    "10/98",
    "07/00",
    "09/01")
risk.labels = c(
    "Black Monday",
    "Bond Crash",
    "Asian Crisis",
    "Russian Crisis",
    "LTCM",
    "Tech Bubble",
    "Sept 11")
data(edhec)
#use subset instead of accessing the column directly to preserve row and column names
R=subset(edhec,select="Funds.of.Funds")
Return.cumulative = cumprod.column(1+R) - 1
chart.TimeSeries(Return.cumulative)
chart.TimeSeries(Return.cumulative, colorset = "darkblue", legend.loc = "bottomright", period.areas = cycles.dates, period.color = "lightblue", event.lines = risk.dates, event.labels = risk.labels, event.color = "red", lwd = 2)



