### Name: Matlab
### Title: Matlab client for remote or local Matlab access
### Aliases: Matlab
### Keywords: classes

### ** Examples
## Not run: 
##D # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
##D # This example will try to start the Matlab server on the local machine,
##D # and then setup a Matlab object in R for communicating data between R
##D # and Matlab and for sending commands from R to Matlab.
##D # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
##D # Start Matlab server on the local machine (if this fails,
##D # see help(Matlab) for alternatives).
##D Matlab$startServer()
##D 
##D # Create a Matlab client object used to communicate with Matlab
##D matlab <- Matlab()
##D 
##D # If you experience any problems, ask for detailed outputs
##D # by uncommenting the next line
##D # setVerbose(matlab, -2)
##D 
##D # Connect to the Matlab server, which must already be running
##D if (!open(matlab))
##D   throw("Matlab server is not running: waited 30 seconds.")
##D 
##D # Run Matlab expressions on the Matlab server
##D evaluate(matlab, "A=1+2;", "B=ones(2,20);")
##D 
##D # Get Matlab variables
##D data <- getVariable(matlab, c("A", "B"))
##D cat("Received variables:\n")
##D str(data)
##D 
##D # Set variables in Matlab
##D ABCD <- matrix(rnorm(10000), ncol=100)
##D str(ABCD)
##D setVariable(matlab, ABCD=ABCD)
##D 
##D # Retrieve what we just set
##D data <- getVariable(matlab, "ABCD")
##D cat("Received variables:\n")
##D str(data)
##D 
##D # Create a function (M-file) on the Matlab server
##D setFunction(matlab, "          \
##D   function [win,aver]=dice(B)  \
##D   %Play the dice game B times  \
##D   gains=[-1,2,-3,4,-5,6];      \
##D   plays=unidrnd(6,B,1);        \
##D   win=sum(gains(plays));       \
##D   aver=win/B;                  \
##D ");
##D 
##D evaluate(matlab, "[w,a]=dice(1000);")
##D res <- getVariable(matlab, c("w", "a"))
##D print(res)
##D 
##D # When done, close the Matlab client, which will also shutdown
##D # the Matlab server and the connection to it.
##D close(matlab)
##D 
## End(Not run)


