### Name: finalize.Object
### Title: Finalizer methods called when object is clean out
### Aliases: finalize.Object Object.finalize finalize.Object
###   finalize,Object-method
### Keywords: internal methods programming

### ** Examples

  setConstructorS3("MyClass", function() {
    extend(Object(), "MyClass")
  })

  setMethodS3("finalize", "MyClass", function(this) {
    cat(as.character(this), "is about to be removed from the memory!\n")
  })

  o <- MyClass()
  o <- MyClass()
  o <- MyClass()
  o <- MyClass()
  gc()

  ## Not run: 
##D   MyClass: 0x01BE602C is about to be removed from the memory!
##D   MyClass: 0x01BFF634 is about to be removed from the memory!
##D   MyClass: 0x01C13584 is about to be removed from the memory!
##D            used (Mb) gc trigger (Mb)
##D   Ncells 229903  6.2     467875 12.5
##D   Vcells  53725  0.5     786432  6.0
##D   
## End(Not run)

  rm(o)
  ## Not run: 
##D   MyClass: 0x01C578B0 is about to be removed from the memory!
##D            used (Mb) gc trigger (Mb)
##D   Ncells 229903  6.1     467875 12.3
##D   Vcells  53725  0.5     786432  6.0
##D   
## End(Not run)



