### Name: HMMFit
### Title: Fit a Hidden Markov Model
### Aliases: HMMFit HMMFitClass summary.HMMFitClass
###   print.summary.HMMFitClass
### Keywords: htest

### ** Examples

    data(geyser)
    obs <- geyser$duration
    #Fits an 2 states gaussian model for geyser duration
    ResGeyser1 <- HMMFit(obs)
    # fit a 3 states gaussian HMM for geyser duration
    # with iterations printing and kmeans initialization
    ResGeyser2 <- HMMFit(obs, nStates=3, paramBW=list(verbose=1, init="KMEANS"))
    # fit a 2 states of a mixture of 3 normal distributions
    # for data_mixture
    data(data_mixture)
    ResMixture <- HMMFit(data_mixture, nStates=2, nMixt=3, dis="MIXTURE")
    summary(ResMixture)
    # geyser data - 3 states HMM with bivariate normal distribution
    ResGeyser<-HMMFit(obs=as.matrix(geyser), nStates=3)
    # multiple samples discrete observations
    data(weather)
    ResDiscrete <- HMMFit(obs=weather, nStates=3, dis="DISCRETE")



