### Name: HMMSet
### Title: Set the parameters for the hidden Markov models
### Aliases: HMMSet HMMClass
### Keywords: models distribution

### ** Examples

    # 3 hidden states Markov Model with univariate normal distributions
    # for the observations
    #   obs | hidden state = 1 are N(1, 1)
    #   obs | hidden state = 2 are N(-2, 2)
    #   obs | hidden state = 3 are N(5, 4)

        n_1d_3s <- distributionSet("NORMAL", c(1, -2, 5), c(1, 2, 4))
        initProb3 <- rep(1,3)/3
        transMat3 <- rbind(c(0.5, 0.4, 0.1), c(0.3, 0.4, 0.3),
            c(0.2, 0.1, 0.7))
        hmm1 <- HMMSet(initProb3, transMat3, n_1d_3s)
        # or directly
        hmm2 <- HMMSet(initProb3, transMat3, "NORMAL", mean=c(1, -2, 5),
            var=c(1, 2, 4))
 


