### Name: HMMSim
### Title: Simulation of an Hidden Markov Model
### Aliases: HMMSim
### Keywords: datagen distribution

### ** Examples

    # simulate a 3 hidden states model with univariate normal distributions
    n_1d_3s <- distributionSet("NORMAL", mean=c(1, -2, 5), var=c(1, 2, 4))
    initProb3 <- rep(1,3)/3
    transMat3 <- rbind(c(0.5, 0.4, 0.1), c(0.3, 0.4, 0.3), c(0.2, 0.1, 0.7))
    hmm_1d_3s <- HMMSet(initProb3, transMat3, n_1d_3s)
    simul <- HMMSim(1000, hmm_1d_3s)
    
    #Simulate 1000 more observations
    simulMore <- HMMSim(1000, hmm_1d_3s, simul$states[1000])  
    


