### Name: distributionSet
### Title: Set the parameters for the distributions of observations
### Aliases: distributionSet distributionClass
### Keywords: models distribution

### ** Examples

    # 3 hidden states Markov Model with univariate normal distributions
    # for the observations
    #   obs | hidden state = 1 are N(1, 1)
    #   obs | hidden state = 2 are N(-2, 2)
    #   obs | hidden state = 3 are N(5, 4)
        n_1d_3s <- distributionSet("NORMAL", mean=c(1, -2, 5), var=c(1, 2, 4))
    # 2 hidden states Markov Model with bivariate normal distributions
    # for the observations
    #   obs | hidden state = 1 are N(m1, cov1)
    #   obs | hidden state = 2 are N(m2, cov2)
        m1 <- c(1,1)
        m2 <- c(-2, -2)
        cov1 <- matrix(c(1, 1, 1, 4), nrow=2)
        cov2 <- matrix(c(1, -1, -1, 9), nrow=2)
        n_2d_2s <- distributionSet("NORMAL", mean=list(m1, m2),
                                        cov=list(cov1, cov2))
    # 3 hidden states Markov Model with a mixture of two normal
    # distributions for the observations
    # obs | hidden state = i are:
    #   pi[1] * N(mmi[1], vari[1]) + pi[2] * N(mmi[2], vari[2])

        mm1 <- c(1, -1)
        mm2 <- c(-2, 2)
        mm3 <- c(5, 5)
        var1 <- c(1, 2)
        var2 <- c(2, 3)
        var3 <- c(1, 1)
        p1 <- c(0.5, 0.5)
        p2 <- c(0.8, 0.2)
        p3 <- c(0.3, 0.7)
        mn_2s <- distributionSet("MIXTURE", mean=list(mm1, mm2, mm3),
            var=list(var1, var2, var3), proportion=list(p1, p2, p3))
    # 2 hidden states Markov Model with discrete observations
        dp1 <- c(0.2, 0.3, 0.3, 0.2)
        dp2 <- c(0.1, 0.1, 0.1, 0.7)
        labels <- c("I", "M", "A", "G")
        d_2s <- distributionSet("DISCRETE", proba=list(dp1, dp2),
                                labels=labels)
    # 2 hidden states Markov model with mixture of 3 2-d gaussian distribution
        q1 <- rep(1/3, 3)
        q2 <- runif(3)
        q2 <- q2/sum(q2)
        cov3 <- matrix(c(1,2,2,10), nrow=2)
        cov4 <- matrix(c(1, 0, 0, 1), nrow=2)
        cov5 <- matrix(c(2,4,4,50), nrow=2)
        cov6 <- matrix(c(25,1, 1, 2), nrow=2)
        mm4 <- c(100, 20)
        mm5 <- c(20, -20)
        mm6 <- c(0, 0)
        m_2d_2s <- distributionSet("MIXTURE", mean=list(list(mm1,mm2,mm3), list(mm4,mm5,mm6)), 
            cov=list(list(cov1,cov2,cov3), list(cov4,cov5,cov6)), proportion=list(q1,q2))
        



