### Name: devSVGTips
### Title: A graphics device for SVG with dynamic tips and hyperlinks
### Aliases: devSVGTips
### Keywords: device

### ** Examples

library("RSVGTipsDevice")
devSVGTips("svgplot1.svg", toolTipMode=1, title="SVG example plot 1: shapes and points, tooltips are title + 1 line")
plot(c(0,10),c(0,10), type="n", xlab="x", ylab="y", main="Example SVG plot with title+ 1 line tips (mode=1)")
setSVGShapeToolTip(title="A rectangle", desc="that is yellow")
rect(1,1,4,6, col='yellow')
setSVGShapeToolTip(title="1st circle with title only")
points(5.5,7.5,cex=20,pch=19,col='red')
setSVGShapeToolTip(title="A triangle", desc="big and green")
polygon(c(3,6,8), c(3,6,3), col='green')
# no tooltips on these points
points(2:8, 8:2, cex=3, pch=19, col='black')
# tooltips on each these points
invisible(sapply(1:7, function(x) {setSVGShapeToolTip(title=paste("point", x)); points(x+1, 8-x, cex=3, pch=1, col='black')}))
dev.off()

## Not run: 
##D # Not run in tests because uses the SemiPar package for the fuel.frame data
##D # A plot of fuel mileage vs weight
##D library("RSVGTipsDevice")
##D library("SemiPar")
##D data(fuel.frame)
##D fuel.frame <- cbind(fuel.frame,
##D     US=is.element(substring(fuel.frame$car.name, 1, 5),
##D                   c("Buick", "Chevr", "Chrys", "Dodge", "Eagle",
##D                     "Ford ", "Mercu", "Oldsm", "Plymo", "Ponti")))
##D devSVGTips("mlgvswgt1.svg", height=5, width=7, toolTipMode=1, title="Mileage vs Weight for autos, tooltips are title + 1 line")
##D plot(fuel.frame$Weight, fuel.frame$Mileage, type="n", xlab="Weight",
##D ylab="Miles per gallon", main="US cars in blue, imports in yellow")
##D for (i in seq(len=nrow(fuel.frame))) {
##D     setSVGShapeToolTip(title=fuel.frame[i,"car.name"],
##D         desc=paste(fuel.frame[i, "Type"], ", disp=", fuel.frame[i,"Disp."]))
##D     points(fuel.frame[i,"Weight"], fuel.frame[i,"Mileage"], pch=19,
##D         cex=2, col=if (fuel.frame[i,"US"]) "blue" else "yellow")
##D }
##D dev.off()
## End(Not run)



