### Name: HIV
### Title: Closed Population Epidemiological Data
### Aliases: HIV
### Keywords: datasets

### ** Examples

data(HIV)
desc<-descriptive(HIV,dfreq=TRUE)
desc
  # 1774 out of 1896 individuals (94%) appear on one list only.

plot(desc)
  # The fi plot is linear showing that heterogeneity is not a problem.  
  # Models with a time (or list) effect and possible pairwise dependencies 
  # between lists will be considered.

mat<-histpos.t(4)
mX1<-cbind(mat,mat[,1]*mat[,2],mat[,1]*mat[,3],mat[,1]*mat[,4],
           mat[,2]*mat[,3],mat[,2]*mat[,4],mat[,3]*mat[,4])
cp.m1<-closedp.mX(HIV,dfreq=TRUE,mX=mX1,mname="Mt double interaction")
cp.m1
  # The model fits well. Let's find out the interactions that are important.
summary(cp.m1$glm)$coefficients
  # Eliminating the non significant interactions stepwise shows that only 
  # the [1,2] interaction is important.

mX2<-cbind(mat,mat[,1]*mat[,2])
closedp.mX(HIV,dfreq=TRUE,mX=mX2,mname="Mt interaction 1,2")
profileCI(HIV,dfreq=TRUE,mX=mX2,mname="Mt interaction 1,2")



