### Name: fwdtr
### Title: Maximum likelihood estimates of transformation parameters
### Aliases: fwdtr
### Keywords: multivariate

### ** Examples
 
## Forward search on untrasformed data 
data(mussels.dat)
l.mle <- fwdtr(mussels.dat)
fwdtrMlePlot(l.mle)

## Forward search on transformed data as specified in vector lamdba 
data(mussels.dat)
l.mle <- fwdtr(mussels.dat,lambda = c(1, 0.5, 1, 0, 1/3))
fwdtrMlePlot(l.mle)

## estimate a common value of lambda for all the variables and use 1/3 to order Mahalanobis distances in each step of the search
data(mussels.dat)
l.mle <- fwdtr(mussels.dat, lambda = 1/3, one.lambda = TRUE)
fwdtrMlePlot(l.mle)

### Test variables 2 and 5
### The forward is based on untransformed data for variables 1, 3 and 4
### sqrt for variable 2 and third root for variable 5
l.mle <- fwdtr(mussels.dat, lambda = c(0.5, 1/3), col.to.transform = c(2, 5))
fwdtrMlePlot(l.mle)



