### Name: fwdtrProfilePlot
### Title: Plot method for profile.fwdtr objects
### Aliases: fwdtrProfilePlot
### Keywords: hplot

### ** Examples
data(mussels.dat)

## Forward search on untransformed data 
## Compute max lik. estimates of tramsformation parameters

l.mle <- fwdtr(mussels.dat)

## Compute profile loglikelihoods for transformation parameters in the
## last step of the search and create an object of class profile.fwdtr

l.profile.mle <- profile.fwdtr(l.mle)

## plot the profile loglikelihoods of transformation parameters for
## each variable 

fwdtrProfilePlot(l.profile.mle)

## Test variables 2 and 5
## The forward is based on untransformed data for variables 1, 3 and 4
## sqrt for variable 2 and third root for variable 5

l.mle <- fwdtr(mussels.dat, lambda = c(0.5, 1/3), col.to.transform = c(2, 5))

## build profile likelihood for transformed variables.
## Profile function takes into account that we have also untransformed variables.

l.profile.mle <- profile.fwdtr(l.mle)
fwdtrProfilePlot(l.profile.mle)



