### Name: profile.fwdtr
### Title: Profile log-likelihood estimates of transformation parameters
### Aliases: profile.fwdtr
### Keywords: multivariate

### ** Examples
data(mussels.dat)

## Forward search on untransformed data 
## Compute max lik. estimates of tramsformation parameters

l.mle <- fwdtr(mussels.dat)

## Compute profile loglikelihoods for transformation parameters in the
## last step of the search and create an object of class profile.fwdtr

l.profile.mle <- profile.fwdtr(l.mle)

## plot the profile loglikelihoods of transformation parameters for
## each variable

fwdtrProfilePlot(l.profile.mle)

## Forward search on transformed data as specified in vector lamdba 

data(mussels.dat)
l.mle <- fwdtr(mussels.dat, lambda = c(1, 0.5, 1, 0, 1/3))

## Compute profile loglikelihoods for transformation parameters in the
## last step of the search and create an object of class profile.fwdtr

l.profile.mle <- profile.fwdtr(l.mle) 

## plot the profile loglikelihoods of transformation parameters for
## each variable

fwdtrProfilePlot(l.profile.mle)

## estimate a common value of lambda for all the variables and use 1/3
## to order Mahalanobis distances in each step of the search

data(mussels.dat)
l.mle <- fwdtr(mussels.dat, lambda = 1/3, one.lambda = TRUE)
l.profile.mle <- profile.fwdtr(l.mle)
fwdtrProfilePlot(l.profile.mle)

## Test variables 2 and 5
## The forward is based on untransformed data for variables 1, 3 and 4
## sqrt for variable 2 and third root for variable 5

l.mle <- fwdtr(mussels.dat, lambda = c(0.5, 1/3), col.to.transform = c(2, 5))
l.profile.mle <- profile.fwdtr(l.mle)
fwdtrProfilePlot(l.profile.mle)



