rlsOptIC.AL              package:RobLox              R Documentation

_C_o_m_p_u_t_a_t_i_o_n _o_f _t_h_e _o_p_t_i_m_a_l_l_y _r_o_b_u_s_t _I_C _f_o_r _A_L _e_s_t_i_m_a_t_o_r_s

_D_e_s_c_r_i_p_t_i_o_n:

     The function 'rlsOptIC.AL' computes the optimally robust IC for 
     AL estimators in case of normal location with unknown scale and 
     (convex) contamination neighborhoods. The definition of  these
     estimators can be found in Section 8.2 of Kohl (2005).

_U_s_a_g_e:

     rlsOptIC.AL(r, mean = 0, sd = 1, A.loc.start = 1, a.sc.start = 0, 
                 A.sc.start = 0.5, bUp = 1000, delta = 1e-6, itmax = 100, 
                 check = FALSE, computeIC = TRUE)

_A_r_g_u_m_e_n_t_s:

       r: non-negative real: neighborhood radius. 

    mean: specified mean.

      sd: specified standard deviation.

A.loc.start: positive real: starting value for  the standardizing
          constant of the location part. 

a.sc.start: real: starting value for centering constant of the scale
          part. 

A.sc.start: positive real: starting value for  the standardizing
          constant of the scale part. 

     bUp: positive real: the upper end point of the  interval to be
          searched for the clipping bound b. 

   delta: the desired accuracy (convergence tolerance). 

   itmax: the maximum number of iterations. 

   check: logical: should constraints be checked. 

computeIC: logical: should IC be computed. See details below. 

_D_e_t_a_i_l_s:

     The Lagrange multipliers contained in the expression of the
     optimally robust IC can be accessed via the accessor functions
     'cent', 'clip' and 'stand'. If 'computeIC' is 'FALSE' only the
     Lagrange multipliers 'A', 'a',  and 'b' contained in the optimally
     robust IC are computed.

_V_a_l_u_e:

     If 'computeIC' is 'TRUE' an object of class '"ContIC"' is
     returned,  otherwise a list of Lagrane multipliers 

       A: standardizing matrix 

       a: centering vector 

       b: optimal clipping bound 

_A_u_t_h_o_r(_s):

     Matthias Kohl Matthias.Kohl@stamats.de

_R_e_f_e_r_e_n_c_e_s:

     Rieder, H. (1994) _Robust Asymptotic Statistics_. New York:
     Springer.

     Kohl, M. (2005) _Numerical Contributions to the Asymptotic Theory
     of Robustness_.  Bayreuth: Dissertation.

_S_e_e _A_l_s_o:

     'ContIC-class', 'roblox'

_E_x_a_m_p_l_e_s:

     IC1 <- rlsOptIC.AL(r = 0.1, check = TRUE)
     distrExOptions("ErelativeTolerance" = 1e-12)
     checkIC(IC1)
     distrExOptions("ErelativeTolerance" = .Machine$double.eps^0.25) # default
     Risks(IC1)
     cent(IC1)
     clip(IC1)
     stand(IC1)
     plot(IC1)
     infoPlot(IC1)

     ## one-step estimation
     ## see also: ?roblox
     ## 1. data: random sample
     ind <- rbinom(100, size=1, prob=0.05) 
     x <- rnorm(100, mean=0, sd=(1-ind) + ind*9)
     mean(x)
     sd(x)
     median(x)
     mad(x)

     ## 2. Kolmogorov(-Smirnov) minimum distance estimator
     ## -> we use it as initial estimate for one-step construction
     (est0 <- ksEstimator(x=x, Norm()))

     ## 3. one-step estimation: radius known
     IC1 <- rlsOptIC.AL(r = 0.5, mean = est0$mean, sd = est0$sd)
     (est1 <- oneStepEstimator(x, IC1, est0))

     ## 4. one-step estimation: radius unknown
     ## take least favorable radius r = 0.579
     ## cf. Table 8.1 in Kohl(2005)
     IC2 <- rlsOptIC.AL(r = 0.579, mean = est0$mean, sd = est0$sd)
     (est2 <- oneStepEstimator(x, IC2, est0))

