rlsOptIC.M              package:RobLox              R Documentation

_C_o_m_p_u_t_a_t_i_o_n _o_f _t_h_e _o_p_t_i_m_a_l_l_y _r_o_b_u_s_t _I_C _f_o_r _M _e_s_t_i_m_a_t_o_r_s

_D_e_s_c_r_i_p_t_i_o_n:

     The function 'rlsOptIC.M' computes the optimally robust IC for  M
     estimators in case of normal location with unknown scale and 
     (convex) contamination neighborhoods. The definition of  these
     estimators can be found in Section 8.3 of Kohl (2005).

_U_s_a_g_e:

     rlsOptIC.M(r, ggLo = 0.5, ggUp = 1.5, a1.start = 0.75, a3.start = 0.25, 
                bUp = 1000, delta = 1e-05, itmax = 100, check = FALSE)

_A_r_g_u_m_e_n_t_s:

       r: non-negative real: neighborhood radius. 

    ggLo: non-negative real: the lower end point of the interval to be
          searched  for gamma. 

    ggUp: positive real: the upper end point of the interval to be
          searched  for gamma. 

a1.start: real: starting value for alpha_1. 

a3.start: real: starting value for alpha_3. 

     bUp: positive real: upper bound used in the  computation of the
          optimal clipping bound b. 

   delta: the desired accuracy (convergence tolerance). 

   itmax: the maximum number of iterations. 

   check: logical. Should constraints be checked. 

_D_e_t_a_i_l_s:

     The optimal values of the tuning constants alpha_1,  alpha_3, b
     and gamma can be read off  from the slot 'Infos' of the resulting
     IC.

_V_a_l_u_e:

     Object of class '"IC"'

_A_u_t_h_o_r(_s):

     Matthias Kohl Matthias.Kohl@stamats.de

_R_e_f_e_r_e_n_c_e_s:

     Huber, P.J. (1981) _Robust Statistics_. New York: Wiley.

     Kohl, M. (2005) _Numerical Contributions to the Asymptotic Theory
     of Robustness_.  Bayreuth: Dissertation.

_S_e_e _A_l_s_o:

     'IC-class'

_E_x_a_m_p_l_e_s:

     IC1 <- rlsOptIC.M(r = 0.1, check = TRUE)
     distrExOptions("ErelativeTolerance" = 1e-12)
     checkIC(IC1, NormLocationScaleFamily())
     distrExOptions("ErelativeTolerance" = .Machine$double.eps^0.25)
     Risks(IC1)
     Infos(IC1)
     plot(IC1)
     infoPlot(IC1)

