### Name: rlsOptIC.AL
### Title: Computation of the optimally robust IC for AL estimators
### Aliases: rlsOptIC.AL
### Keywords: robust

### ** Examples

IC1 <- rlsOptIC.AL(r = 0.1, check = TRUE)
distrExOptions("ErelativeTolerance" = 1e-12)
checkIC(IC1)
distrExOptions("ErelativeTolerance" = .Machine$double.eps^0.25) # default
Risks(IC1)
cent(IC1)
clip(IC1)
stand(IC1)
plot(IC1)
infoPlot(IC1)

## one-step estimation
## see also: ?roblox
## 1. data: random sample
ind <- rbinom(100, size=1, prob=0.05) 
x <- rnorm(100, mean=0, sd=(1-ind) + ind*9)
mean(x)
sd(x)
median(x)
mad(x)

## 2. Kolmogorov(-Smirnov) minimum distance estimator
## -> we use it as initial estimate for one-step construction
(est0 <- ksEstimator(x=x, Norm()))

## 3. one-step estimation: radius known
IC1 <- rlsOptIC.AL(r = 0.5, mean = est0$mean, sd = est0$sd)
(est1 <- oneStepEstimator(x, IC1, est0))

## 4. one-step estimation: radius unknown
## take least favorable radius r = 0.579
## cf. Table 8.1 in Kohl(2005)
IC2 <- rlsOptIC.AL(r = 0.579, mean = est0$mean, sd = est0$sd)
(est2 <- oneStepEstimator(x, IC2, est0))



