### Name: roblox
### Title: Optimally robust estimator for location and/or scale
### Aliases: roblox
### Keywords: robust

### ** Examples

ind <- rbinom(100, size=1, prob=0.05) 
x <- rnorm(100, mean=ind*3, sd=(1-ind) + ind*9)

## amount of gross errors known
res1 <- roblox(x, eps = 0.05, returnIC = TRUE)
res1$mean
res1$sd
res1$optIC
checkIC(res1$optIC)
Risks(res1$optIC)
Infos(res1$optIC)
plot(res1$optIC)
infoPlot(res1$optIC)

## amount of gross errors unknown
res2 <- roblox(x, eps.lower = 0.01, eps.upper = 0.1, returnIC = TRUE)
res2$mean
res2$sd
res2$optIC
checkIC(res2$optIC)
Risks(res2$optIC)
Infos(res2$optIC)
plot(res2$optIC)
infoPlot(res2$optIC)

## estimator comparison
# classical optimal (non-robust)
c(mean(x), sd(x))
# most robust
c(median(x), mad(x))
# Kolmogorov(-Smirnov) minimum distance estimator (robust)
ksEstimator(x, distribution = Norm())
# optimally robust (amount of gross errors known)
c(res1$mean, res1$sd)
# optimally robust (amount of gross errors unknown)
c(res2$mean, res2$sd)




