rgsOptIC.ALs             package:RobRex             R Documentation

_C_o_m_p_u_t_a_t_i_o_n _o_f _t_h_e _o_p_t_i_m_a_l_l_y _r_o_b_u_s_t _I_C _f_o_r _A_L_s _e_s_t_i_m_a_t_o_r_s

_D_e_s_c_r_i_p_t_i_o_n:

     The function 'rgsOptIC.ALs' computes the optimally robust IC for
     ALs estimators in case of linear regression with unknown scale and
     (convex) contamination neighborhoods where the regressor is
     random; confer Subsection 7.3.1 of Kohl (2005).

_U_s_a_g_e:

     rgsOptIC.ALs(r, K, A.rg.start, b.rg.Up = 1000, delta = 1e-06, 
                  itmax = 50, check = FALSE)

_A_r_g_u_m_e_n_t_s:

       r: non-negative real: neighborhood radius. 

       K: object of class '"Distribution"'. 

A.rg.start: positive definite and symmetric matrix: starting value for
          the standardizing matrix of the regression part. 

 b.rg.Up: positive real: the upper end point of the interval to be
          searched for b.rg. 

   delta: the desired accuracy (convergence tolerance). 

   itmax: the maximum number of iterations. 

   check: logical. Should constraints be checked. 

_D_e_t_a_i_l_s:

     If 'A.rg.start' is missing, the inverse of the  second moment
     matrix of 'K' is used.

_V_a_l_u_e:

     Object of class '"ContIC"'

_A_u_t_h_o_r(_s):

     Matthias Kohl Matthias.Kohl@stamats.de

_R_e_f_e_r_e_n_c_e_s:

     Rieder, H. (1994) _Robust Asymptotic Statistics_. New York:
     Springer.

     Kohl, M. (2005) _Numerical Contributions to the Asymptotic Theory
     of Robustness_.  Bayreuth: Dissertation.

_S_e_e _A_l_s_o:

     'ContIC-class'

_E_x_a_m_p_l_e_s:

     K <- DiscreteDistribution(1:5) # = Unif({1,2,3,4,5})
     IC1 <- rgsOptIC.ALs(r = 0.1, K = K)
     checkIC(IC1)
     Risks(IC1)
     Infos(IC1)

