rgsOptIC.M              package:RobRex              R Documentation

_C_o_m_p_u_t_a_t_i_o_n _o_f _t_h_e _o_p_t_i_m_a_l_l_y _r_o_b_u_s_t _I_C _f_o_r _M _e_s_t_i_m_a_t_o_r_s

_D_e_s_c_r_i_p_t_i_o_n:

     The function 'rgsOptIC.M' computes the optimally robust IC for M
     estimators in case of linear regression with unknown scale and
     (convex) contamination neighborhoods where the regressor is
     random; confer Subsubsection 7.2.2.1 of Kohl (2005).

_U_s_a_g_e:

     rgsOptIC.M(r, K, A.start, gg.start = 0.6, a1.start = -0.25, 
                 a3.start = 0.25, B.start, bUp = 1000, delta = 1e-05, 
                 MAX = 100, itmax = 1000, check = FALSE)

_A_r_g_u_m_e_n_t_s:

       r: non-negative real: neighborhood radius. 

       K: object of class '"Distribution"'. 

 A.start: positive definite and symmetric matrix: starting value for
          the standardizing matrix of the regression part. 

gg.start: positive real: starting value for  the standardizing constant
          gamma  of the scale part. 

a1.start: real: starting value for  Lagrange multiplier alpha_1. 

a3.start: real: starting value for  Lagrange multiplier alpha_3. 

 B.start: symmetric matrix: starting value for  Lagrange multiplier B. 

     bUp: positive real: the upper end point of the interval to be
          searched for b. 

   delta: the desired accuracy (convergence tolerance). 

     MAX: if A or gamma are beyond the  admitted values, 'MAX' is
          returned. 

   itmax: the maximum number of iterations. 

   check: logical. Should constraints be checked. 

_D_e_t_a_i_l_s:

     The computation of the optimally robust IC for M estimators is
     based on 'optim' where 'MAX' is used to control the constraints on
     A and gamma.

_V_a_l_u_e:

     Object of class '"IC"'

_A_u_t_h_o_r(_s):

     Matthias Kohl Matthias.Kohl@stamats.de

_R_e_f_e_r_e_n_c_e_s:

     Kohl, M. (2005) _Numerical Contributions to the Asymptotic Theory
     of Robustness_.  Bayreuth: Dissertation.

_S_e_e _A_l_s_o:

     'IC-class'

_E_x_a_m_p_l_e_s:

     K <- DiscreteDistribution(1:5) # = Unif({1,2,3,4,5})
     IC1 <- rgsOptIC.M(r = 0.1, K = K)
     checkIC(IC1)
     Risks(IC1)

