### Name: label
### Title: Set or Retreive the 'label', 'SASformat', or 'SASiformat'
###   Attribute of a Vector
### Aliases: label label.default label<- label<-.default SASformat
###   SASformat.default SASformat<- SASformat<-.default SASiformat
###   SASiformat.default SASiformat<- SASiformat<-.default
### Keywords: utilities interface

### ** Examples


fail.time <- c(10,20)

# set attributes
label(fail.time) <- 'Failure Time'
SASformat(fail.time) <- 'Numeric2'
SASiformat(fail.time) <- 'Numeric2'

# display individual attributes
label(fail.time)
SASformat(fail.time)
SASiformat(fail.time)

# display all attributes
attributes(fail.time)

# Example showing specification of default return value
a <- 70
label(a, default="no label")

## Not run: 
##D # for a nice display
##D library(Hmisc)
##D describe(fail.time)
##D 
##D f <- cph(Surv(fail.time, event) ~ xx)
##D plot(xx,xx2,xlab=label(xx),"s",sep=""))
## End(Not run)




