### Name: lookup.xport
### Title: Describe the Contents of an SAS XPORT File
### Aliases: lookup.xport print.lookup.xport summary.lookup.xport
###   print.summary.lookup.xport
### Keywords: file manip

### ** Examples

## Don't show: 
setwd(file.path(.path.package("SASxport"),"data"))
## End Don't show
## Get information on a local file
lookup.xport("Alfalfa.xpt")

## Or read a copy of test2.xpt available on the web:
## Not run: 
##D host <- 'http://biostat.mc.vanderbilt.edu'
##D path <- '/cgi-bin/viewvc.cgi/*checkout*/Hmisc/trunk/tests/test2.xpt'
##D url <- paste(host,path,sep="")
##D 
##D w <- lookup.xport(url)
##D 
##D # display the information (calls 'print.lookup.xport')
##D w
##D 
##D # names of data sets
##D names(w)
##D 
##D # names of variables within data sets
##D w$Z$name
##D 
##D # use summary
##D wS <- summary(w)
##D wS # same display
##D 
##D # variable names within all data sets
##D wS$name 
## End(Not run)




