### Name: read.xport
### Title: Import a SAS XPORT File
### Aliases: read.xport
### Keywords: interface manip

### ** Examples


# -------
# SAS code to generate test dataset:
# -------
# libname y SASV5XPT "test2.xpt";
#
# PROC FORMAT; VALUE race 1=green 2=blue 3=purple; RUN;
# PROC FORMAT CNTLOUT=format;RUN;  * Name, e.g. 'format', unimportant;
# data test;
# LENGTH race 3 age 4;
# age=30; label age="Age at Beginning of Study";
# race=2;
# d1='3mar2002'd ;
# dt1='3mar2002 9:31:02'dt;
# t1='11:13:45't;
# output;
#
# age=31;
# race=4;
# d1='3jun2002'd ;
# dt1='3jun2002 9:42:07'dt;
# t1='11:14:13't;
# output;
# format d1 mmddyy10. dt1 datetime. t1 time. race race.;
# run;
# data z; LENGTH x3 3 x4 4 x5 5 x6 6 x7 7 x8 8;
#    DO i=1 TO 100;
#        x3=ranuni(3);
#        x4=ranuni(5);
#        x5=ranuni(7);
#        x6=ranuni(9);
#        x7=ranuni(11);
#        x8=ranuni(13);
#        output;
#        END;
#    DROP i;
#    RUN;
# PROC MEANS; RUN;
# PROC COPY IN=work OUT=y;SELECT test format z;RUN; *Creates test2.xpt;
# ------

# Read this dataset from a local file:
## Not run: 
##D w <- read.xport('test2.xpt')
## End(Not run)

# Or read a copy of test2.xpt available on the web:
host <- 'http://biostat.mc.vanderbilt.edu'
path <- '/cgi-bin/viewvc.cgi/*checkout*/Hmisc/trunk/tests/test2.xpt'
url <- paste(host,path,sep="")

w <- read.xport(url)

# We can also get the dataset wrapped in a list
w <- read.xport(url, as.list=TRUE)

# And we can ask for the format information to be included as well.
w <- read.xport(url, as.list=TRUE, include.formats=TRUE)

## Don't show: 
SASxport:::assert( is.data.frame(w)==FALSE && is.list(w)==TRUE )
## End Don't show

## Not run: 
##D ## The Hmisc library provides many useful functions for interacting with
##D ## data imported from SAS via read.xport()
##D library(Hmisc)
##D 
##D describe(w$test)   # see labels, format names for dataset test
##D lapply(w, describe)# see descriptive stats in more detaiil for each variable
##D 
##D contents(w$test)   # another way to see variable attributes
##D lapply(w, contents)# show contents of individual items in more detail
##D 
##D options(digits=7)  # compare the following matrix with PROC MEANS output
##D t(sapply(w$z, function(x)
##D  c(Mean=mean(x),SD=sqrt(var(x)),Min=min(x),Max=max(x))))
## End(Not run)




