### Name: write.xport
### Title: Write Data to a SAS XPORT File
### Aliases: write.xport
### Keywords: file

### ** Examples


#####
## R version of the example given in TS-140
#####

## manually create a data set
temp <- data.frame( x=c(1, 2, NA, NA ), y=c('a', 'B', NA, '*' ) )

## look at it
temp

## add a format specifier (not used by R)
attr(temp$x, 'SASformat') <- 'date7.'

## add a variable label (not used by R)
attr(temp$y, 'label')  <- 'character variable'

## verify the additions
str(temp)

## rename the data set
abc <- temp

# create a SAS XPORT file 
write.xport( abc, file="xxx.dat" )

# list the contents of the file
lookup.xport("xxx.dat")

## reload the data
xxx.abc <- read.xport("xxx.dat")

## and look at it
xxx.abc

## Note that the variable names have been converted to uppercase




