### Name: Complete
### Title: Get a completion list for a R code fragment
### Aliases: Complete
### Keywords: utilities

### ** Examples

    ## a data.frame
    data(iris)
        cat(Complete("item <- iris$"), "\n")
        cat(Complete("item <- iris[[", TRUE), "\n")
        
        ## An S4 object
    setClass("track", representation(x = "numeric", y = "numeric"))
    t1 <- new("track", x=1:20, y=(1:20)^2)
    cat(Complete("item2 <- t1@", TRUE), "\n")
    
    ## A partial identifier
    cat(Complete("item3 <- va", TRUE), "\n")
    
    ## Otherwise, a list with the content of .GlobalEnv
    cat(Complete("item4 <- "), "\n")



