### Name: wordReport
### Title: Manage a report in Microsoft Word from within R
### Aliases: WordOpen WordActivate WordExit WordGoto WordGotoEnd
###   WordInsertPara WordInsertPageBreak WordInsertText WordInsertFile
###   WordInsertPictureFile WordExec
### Keywords: print interface

### ** Examples

    ## Not run: 
##D         WordOpen()      # Open Miscrosoft Word with a new empty document (or activate current doc)
##D                 WordGotoEnd() # Move insertion point to the end of that document
##D                 # Insert some text in it
##D                 WordInsertText("Some \ttext...\nOther text after line feed in same para\rOther para\fOther page")
##D                 # Insert a new paragraph
##D                 WordInsertPara()
##D 
##D                 # Open an existing Word document (it must exist there, of course!)
##D                 WordOpen("c:/temp/test.doc")
##D                 WordGoto() # Display the GoTo dialog box in Word, and allow to navigate to a given place or bookmark manually
##D                 WordInsertPictureFile("c:/temp/test.emf")       # Insert a picture there (he file must exist, of course!)
##D                 WordGoto("my bookmark") # Go to the "my bookmark" bookmark (it must exist, otherwise an error is issued in Word!)
##D                 WordInsertFile("c:/temp/test.html", "testit") # Insert a piece of HTML there (the file must exist, of course!)
##D                 WordExit()      # Close word, possibly prompting to save all unsaved documents before.
##D     
## End(Not run)



