### Name: Img
### Title: Manipulate image resources for the GUIs
### Aliases: ImgGet ImgNames ImgType tkImgAdd tkImgDel tkImgReadPackage
### Keywords: utilities

### ** Examples

  ## Not run: 
##D     ## These cannot be run by examples() but should be OK when pasted
##D     ## into an interactive R session with the tcltk package loaded
##D 
##D         ImgNames()
##D         tkImgAdd(file.path(.path.package(package = "svWidgets")[1], "gui", "logoSciViews.gif"))
##D         ImgNames()
##D         ImgType("$Tk.logoSciViews")
##D         # Place that logo in a Tk window
##D         timg <- tkWinAdd("timg", title = "A Tk window with image", pos ="-40+20")
##D         labImg <- tklabel(timg, image = ImgGet("$Tk.logoSciViews"), bg = "white")
##D         tkpack(labImg)
##D         # When the image resource is deleted, it is not displayed any more, but there is no error
##D         tkImgDel("$Tk.logoSciViews")
##D         ImgNames()
##D         tkWinDelete("timg")
##D         # To read all image resources at once (place this in .Lib.first())
##D         tkImgReadPackage("svWidgets")
##D         ImgNames()
##D   
## End(Not run)



