### Name: Menu
### Title: Conveniently manipulate menus, whatever the window
### Aliases: MenuAdd MenuAddItem MenuDel MenuDelItem MenuNames MenuItems
###   MenuType MenuChangeItem MenuStateItem MenuRead MenuReadPackage
### Keywords: utilities

### ** Examples

  ## Not run: 
##D     ## These cannot be run by examples() but should be OK when pasted
##D     ## into an interactive R session with the tcltk package loaded
##D         ## Run these commands one at a time and look at menus...
##D         
##D         # Create menus in Rgui, using a specification file
##D         MenuReadPackage("svWidgets")
##D         MenuNames()
##D         (MenuItems("$ConsoleMain/Testit"))
##D         
##D         # Create menus manually in Rgui
##D     MenuAdd("$ConsoleMain/Testit2")
##D         MenuAddItem("$ConsoleMain/Testit2", "Trial", "ls()")
##D         MenuNames()
##D         (MenuItems("$ConsoleMain/Testit2"))
##D         MenuStateItem("$ConsoleMain/Testit2", "Trial", FALSE)
##D         MenuStateItem("$ConsoleMain/Testit2", "Trial", TRUE)
##D         # This is buggy! -> MenuChangeItem("$ConsoleMain/Testit2", "Trial", "search()")
##D         (MenuItems("$ConsoleMain/Testit2"))
##D         
##D         # Create and manipulate Tk menus
##D         tkWinAdd("tt", title = "A Tk window with menus", pos ="-40+20")
##D         MenuAdd("$Tk.tt/Misc")
##D         MenuNames()
##D         (MenuItems("$Tk.tt/Misc"))   # Still nothing in it
##D         MenuAddItem("$Tk.tt/Misc", "List &variables", "print(ls(envir = .GlobalEnv))")
##D         MenuAddItem("$Tk.tt/Misc", "Say &yo!", "cat('yo!\n')")
##D 
##D         MenuDelItem("$Tk.tt/Misc", "Say &yo!")
##D         MenuAddItem("$Tk.tt/Misc", "-")
##D         MenuAddItem("$Tk.tt/Misc", "&Say yo! twice", "cat('yo! yo!\n')")
##D         (MenuItems("$Tk.tt/Misc"))
##D 
##D         tkImgReadPackage("svWidgets")   # Make sure images are loaded
##D         MenuAdd("$Tk.tt/Misc/Sub&Menu")
##D         MenuAddItem("$Tk.tt/Misc/Sub&Menu", "T&rial", "cat('Trial trigerred!\n')")
##D         MenuAddItem("$Tk.tt/Misc", "Tria&l2", "cat('Trail with image and accel!\n')",
##D                 image = "$Tk.butOpen", accel = "Ctrl+T")
##D         MenuNames()
##D         (MenuItems("$Tk.tt/Misc"))
##D         MenuStateItem("$Tk.tt/Misc", "Tria&l2", FALSE)
##D         MenuStateItem("$Tk.tt/Misc", "Tria&l2", TRUE)
##D         MenuStateItem("$Tk.tt/Misc", "Sub&Menu", FALSE)
##D         MenuStateItem("$Tk.tt/Misc", "Sub&Menu", TRUE)
##D         MenuChangeItem("$Tk.tt/Misc", "Tria&l2", options = "underline = 1")
##D         # This is the way to change binding
##D         tkbind(WinGet("tt"), "<Control-r>", function() tkMenuInvoke("$Tk.tt/Misc", "Tria&l2"))
##D         MenuChangeItem("$Tk.tt/Misc", "Tria&l2", action = 'cat("new action for Tria&l2!\n")')
##D         tkMenuInvoke("$Tk.tt/Misc", "Tria&l2")
##D         (MenuItems("$Tk.tt/Misc"))
##D         MenuDelItem("$Tk.tt/Misc", "Tria&l2")
##D         MenuDel("$Tk.tt/Misc")
##D         MenuNames()
##D         (MenuItems("$Tk.tt/Misc"))
##D         tkWinDelete("tt")
##D   
## End(Not run)



