### Name: SNPlong.dat
### Title: Example genotypic data for longitudinal analysis
### Aliases: SNPlong.dat
### Keywords: datasets

### ** Examples


data(SNPlong.dat)

# transforms SNPlong.dat to an object containing 3 columns
# per SNP - additive, dominant and recessive, where genotypes
# defined in 'baseline' serve as the baseline genotypes
longGeno.dat <- SNP2Geno(SNPlong.dat, baseline=c("AA", "GG", "V2V2"))

data(longPheno.dat)
mymodel <- snp.long(fixed=fev1f~SNP_1_add, random=~1|id, 
        geno=longGeno.dat, pheno=longPheno.dat, form=~year|id)
summary(mymodel)




