### Name: haplo.cc.match
### Title: Haplotype analysis for matched case-control data
### Aliases: haplo.cc.match
### Keywords: models

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat) 

# prints haplotype frequencies among cases
myinfer$hap.freq.cases

# prints haplotype frequencies among controls
myinfer$hap.freq.controls

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05)

mymodel <- haplo.cc.match(formula1=DISEASE~SBP+DBP+h.N1AA+strata(STRAT), 
        formula2=DISEASE~SBP+DBP+strata(STRAT), haplo=myhaplo, 
        pheno=pheno.dat, sim=10)
summary(mymodel)

# example using a subsetting variable - looking at males only
mymodel <- haplo.cc.match(formula1=DISEASE~SBP+DBP+h.N1AA+strata(STRAT), 
        formula2=DISEASE~SBP+DBP+strata(STRAT), haplo=myhaplo, 
        pheno=pheno.dat, sim=10, sub=expression(SEX==1))
summary(mymodel)




