### Name: haplo.long
### Title: Haplotype analysis for a longitudinal data
### Aliases: haplo.long
### Keywords: models

### ** Examples


data(SNPlong.dat)

# convert SNP.dat to format required by infer.haplos
longHaplo.dat <- SNP2Haplo(SNPlong.dat)

data(longPheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(longHaplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq 

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05)

mymodel <- haplo.long(fixed=fev1f~h.ACV2, random=~1|id, 
        pheno=longPheno.dat, haplo=myhaplo, form=~year|id, sim=10)
summary(mymodel)

# example with a subsetting variable - looking at males only
mymodel <- haplo.long(fixed=fev1f~height+h.ACV2, random=~1|id, 
        pheno=longPheno.dat, haplo=myhaplo, form=~year|id, sim=10, 
        sub=expression(sex==1))
summary(mymodel)




