### Name: haplo.quant
### Title: Haplotype analysis for a Normally distributed quantitative trait
### Aliases: haplo.quant
### Keywords: models

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat)

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq 

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.quant(formula1=HDL~AGE+SBP+h.N1AA, 
        formula2=HDL~AGE+SBP, pheno=pheno.dat, haplo=myhaplo, sim=10)
summary(mymodel)

# example using a variable for which to predict marginal means
mymodel <- haplo.quant(formula1=HDL~AGE+SBP+factor(h.N1AA), 
        formula2=HDL~AGE+SBP, pheno=pheno.dat, haplo=myhaplo, sim=10, 
        predict_variable="h.N1AA")
summary(mymodel)

# example with a subsetting variable, looking at males only
# and modelling a dominant haplotypic effect
mymodel <- haplo.quant(formula1=HDL~AGE+SBP+h.N1AA, formula2=HDL~AGE+SBP, 
        pheno=pheno.dat, haplo=myhaplo, sim=10, effect="dom", 
        sub=expression(SEX==1))





