### Name: haplo.surv
### Title: Haplotype analysis for survival data
### Aliases: haplo.surv
### Keywords: models

### ** Examples


data(SNPsurv.dat)

# convert SNP.dat to format required by infer.haplos
survHaplo.dat <- SNP2Haplo(SNPsurv.dat)

data(survPheno.dat)

# generate haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(survHaplo.dat) 

# print haplotype frequencies generated by infer.haplos
myinfer$hap.freq 

# generate haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05)

mymodel <- haplo.surv(formula1=Surv(time, status)~age+h.V1AA, 
        formula2=Surv(time, status)~age, haplo=myhaplo, 
        pheno=survPheno.dat, sim=10)
summary(mymodel)

# example using a subsetting variable - looking at males only
mymodel <- haplo.surv(formula1=Surv(time, status)~age+h.V1AA, 
        formula2=Surv(time, status)~age, haplo=myhaplo, 
        pheno=survPheno.dat, sim=10, sub=expression(sex==1))
summary(mymodel)




