### Name: infer.haplos
### Title: Infer haplotype configurations when phase is unknown
### Aliases: infer.haplos
### Keywords: manip

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

# generates haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos(haplo.dat) 

# prints haplotype frequencies generated by infer.haplos
myinfer$hap.freq 

# generates haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.quant(formula1=HDL~AGE+SBP+h.N1AA, formula2=HDL~AGE+SBP, 
        pheno=pheno.dat, haplo=myhaplo, sim=10)




