### Name: infer.haplos.cc
### Title: Infer haplotype configuration independently in cases and
###   controls
### Aliases: infer.haplos.cc
### Keywords: manip

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by infer.haplos
haplo.dat <- SNP2Haplo(SNP.dat)

data(pheno.dat)

newdata <- prepare.cc(geno=haplo.dat, pheno=pheno.dat, cc.var="DISEASE")
newhaplo.dat <- newdata$geno
newpheno.dat <- newdata$pheno

# generates haplotype frequencies and haplotype design matrix
myinfer<-infer.haplos.cc(geno=newhaplo.dat, 
        pheno=newpheno.dat, cc.var="DISEASE")

# prints haplotype frequencies among cases
myinfer$hap.freq.cases

# prints haplotype frequencies among controls
myinfer$hap.freq.controls
 
# generated haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.quant(formula1=HDL~AGE+SBP+h.N1AA, formula2=HDL~AGE+SBP, 
        pheno=newpheno.dat, haplo=myhaplo, sim=10)




