### Name: pheno.dat
### Title: Example phenotypic data
### Aliases: pheno.dat
### Keywords: datasets

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by snp.quant
geno.dat <- SNP2Geno(SNP.dat, baseline=c("MM", "11", "GG", "CC"))

data(pheno.dat)

mymodel <- snp.quant(formula1=LDL~AGE+SBP+factor(SNP_1_add),
        formula2=HDL~AGE+SBP, geno=geno.dat, pheno=pheno.dat)
summary(mymodel)

# example with a subsetting variable, looking at males only
mymodel <- snp.quant(formula1=LDL~AGE+SBP+factor(SNP_1_add),
        formula2=HDL~AGE+SBP, geno=geno.dat, pheno=pheno.dat, 
        sub=expression(SEX==1))
 



