### Name: prepare.cc
### Title: Prepare case-control data for inferring haplotypes
### Aliases: prepare.cc
### Keywords: manip

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by infer.haplos.cc
haplo.dat <- SNP2Haplo(SNP.dat)
data(pheno.dat)

# not run: will return an error due to missing data in variable 'DISEASE'
# myinfer<-infer.haplos.cc(geno=haplo.dat, pheno=pheno.dat, 
#       cc.var="DISEASE") 

newdata <- prepare.cc(geno=haplo.dat, pheno=pheno.dat, cc.var="DISEASE")
newhaplo.dat <- newdata$geno
newpheno.dat <- newdata$pheno
myinfer<-infer.haplos.cc(geno=newhaplo.dat, pheno=newpheno.dat, 
        cc.var="DISEASE")

# prints haplotype frequencies among cases
myinfer$hap.freq.cases

# prints haplotype frequencies among controls
myinfer$hap.freq.controls 

# generated haplo object where haplotypes with a frequency 
# below min.freq are grouped as a category called "rare"
myhaplo<-make.haplo.rare(myinfer,min.freq=0.05) 
mymodel <- haplo.bin(formula1=DISEASE~AGE+SBP+h.N1AA, 
        formula2=DISEASE~AGE+SBP, pheno=newpheno.dat, haplo=myhaplo, 
        sim=10)




