### Name: snp.bin
### Title: Single SNP analysis for binary outcomes
### Aliases: snp.bin
### Keywords: models

### ** Examples


data(SNP.dat)

# convert SNP.dat to format required by snp.bin
geno.dat <- SNP2Geno(SNP.dat, baseline=c("MM", "11", "GG", "CC"))
data(pheno.dat)

mymodel <- snp.bin(formula1=PLAQUE~AGE+SEX+SNP_1_add, 
        formula2=PLAQUE~AGE+SEX, geno=geno.dat, pheno=pheno.dat)
summary(mymodel)

# example with a subsetting variable, looking at 
# people over 50 years of age only
mymodel <- snp.bin(formula1=PLAQUE~AGE+SEX+SNP_1_add, 
        formula2=PLAQUE~AGE+SEX, geno=geno.dat, pheno=pheno.dat, 
        sub=expression(AGE>50))




